﻿//////////////////////////////////////////////
// RenderCommand.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Entity ;
	class Mesh ;
	class Shader ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../../../Dll/DllDefines.h"

#include "Enums/RenderCommandType.h"

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT RenderCommand final
	{
		public :

			// Static creation utility
			static RenderCommand draw () ;
			static RenderCommand changeShader (Shader* shader) ;
			static RenderCommand changeMesh (Mesh* mesh) ;
			static RenderCommand prepareInstance (Entity* entity) ;

		public :

			// Potential arguments
			Mesh* _mesh = nullptr ;
			Shader* _shader = nullptr ;

			Entity* _instance = nullptr ;

			RENDER_COMMAND_TYPE _type = RENDER_COMMAND_TYPE::UNKNOWN ;
	} ;
}